KasperskyLab.AddRunner("wsc", function (ns, session)
{
	var WebsiteCredentials = function () {
		var m_callFunction, m_syncCallFunction;
		var m_lastPasswordSended = null;
		var m_subscribedAttributeName = "kl_wsc_" + ns.GetCurrentTime();
		var m_passwordInputObserver = ns.GetDomChangeObserver("input");

		session.InitializePlugin(function (activatePlugin, registerMethod, callFunction, deactivate, syncCall) {
			m_callFunction = callFunction;
			m_syncCallFunction = syncCall;
			activatePlugin("wsc", OnPing, OnError);
		});

		SetEventListeners();
		m_passwordInputObserver.Start(SetEventListeners);
		ns.AddEventListener(window, "unload",
			function()
			{
				if (m_passwordInputObserver)
					m_passwordInputObserver.Stop();
			});

		function OnPing() {
			return ns.MaxRequestDelay;
		}

		function OnError(e) {
			session.Log("ERR WSC - " + (e.message || e));
		}

		function IsVisible(element) {
			var style = window.getComputedStyle ? window.getComputedStyle(element) : element.currentStyle;
			return style.display !== "none";
		}
		function IsSubscribedElement(element)
		{
			return element[m_subscribedAttributeName];
		}
		function MarkSubscribedElement(element)
		{
			element[m_subscribedAttributeName] = true;
		}
		function GetElements(element, tag, type) {
			if (element.querySelectorAll)
				return element.querySelectorAll(tag + "[type='"+type+"']");

			var result = [];
			var childrens = element.getElementsByTagName(tag);
			for (var i = 0; i < childrens.length; i++) {
				if (childrens[i].type.toLowerCase() == type) {
					result.push(childrens[i]);
				}
			}
			return result;
		}

		function GetFormAction(parentForm)
		{
			var formAction = parentForm.action;
			if (typeof(parentForm.action) !== "string" && parentForm.getAttribute)
			{
				var tmp = document.createElement("form");
				tmp.setAttribute("action", parentForm.getAttribute("action"));
				formAction = tmp.action;
			}
			if (formAction && (formAction.toLowerCase().indexOf("http://") === 0 || formAction.toLowerCase().indexOf("https://") === 0))
				return formAction;
			return "";
		}

		function OnSubmitEventListener(element, parentForm) {
			try
			{
				if (IsVisible(element) && !!element.value && element.value != m_lastPasswordSended) {
					m_lastPasswordSended = element.value;
					var hash = ns.md5(element.value) || "";
					var url = GetFormAction(parentForm) || document.location.toString() || "";
					if (!m_syncCallFunction("wsc.WebsiteCredentialSendPasswordHash", [url, hash], null, OnError))
						m_callFunction("wsc.WebsiteCredentialSendPasswordHash", [url, hash], null, OnError);
				}
			}
			catch(e)
			{
				OnError(e);
			}
		}

		function GetCallback(element, parentForm) {
			return function () {
				OnSubmitEventListener(element, parentForm);
			};
		}

		function GetSubmitButtons(parentForm) {
			var result = GetElements(parentForm, 'input', 'submit');
			if (!!result && result.length === 1) 
				return result[0];
			return !!result && result.length > 1 ? result : null;
		}
		function GetSingleButton(parentForm) {
			var buttons = GetElements(parentForm, 'button', 'submit'); 
			if (!!buttons && buttons.length === 1) 
				return buttons[0];
			if (!!buttons && buttons.length > 1) 
				return buttons;
			buttons = parentForm.getElementsByTagName("button");
			if (!!buttons && buttons.length === 1) 
				return buttons[0];
			var result = [];
			for (var i = 0; i < buttons.length; i++) {
				if (IsVisible(buttons[i])) 
					result.push(buttons[i]);
			}
			return result.length === 1 ? result[0] : null;
		}
		function SetEnterKeyEventListener(element, callback)
		{
			ns.AddEventListener(element, "keydown", function(e){ if (e.keyCode===13) callback(); });
		}
		function SetButtonClickEventListener(element, callback)
		{
			ns.AddEventListener(element, "click", callback);
		}
		function SetFormEventListeners(parentForm, element, callback)
		{
			if (!!element)
			{
				if ('length' in element) 
				{
					for(var i=0; i < element.length; ++i) 
					{
						try
						{
							SetButtonClickEventListener(element[i], callback);
							SetEnterKeyEventListener(element[i], callback);
						}
						catch(e)
						{
							session.Log('Error set event handlers for ' + element[i] + '! ' + e);
						}
					}
				} 
				else 
				{
					try
					{
						SetButtonClickEventListener(element, callback);
						SetEnterKeyEventListener(parentForm, callback);
					}
					catch(e)
					{
						session.Log('Error set event handlers for ' + element + '! ' + e);
					}
				}
			}
			ns.AddEventListener(parentForm, "submit", callback);
		}
		function SetEventListeners() {
			var passwordEditors = GetElements(document, "input", "password");
			for (var i = 0, length = passwordEditors.length; i < length; ++i) {
				if (IsSubscribedElement(passwordEditors[i]))
					continue;
				var passwordForm = passwordEditors[i].form || document;
				if (!!passwordForm) {
					var button = GetSubmitButtons(passwordForm) || GetSingleButton(passwordForm);
					var callback = GetCallback(passwordEditors[i], passwordForm);

					SetFormEventListeners(passwordForm, button, callback);
					SetEnterKeyEventListener(passwordEditors[i], callback);
				}
				MarkSubscribedElement(passwordEditors[i]);
			}
		}
	};

	var instance = null;
	ns.RunModule(function()
	{
		try {
			if (!instance) {
				instance = new WebsiteCredentials();
			}
		} catch (e) {
			session.Log("WebsiteCredentials exception: " + (e.message || e));
		}
	});
});
